/*------------------------------------------------------------------------------*
 * File Name: ExternApps.h														*
 * Creation: DVT 12/24/2001														*
 * Purpose: Origin C header file for communication with third party applications*
 * Copyright (c) OriginLab Corp.	2002 - 2007									*
 * All Rights Reserved															*
 * 																				*
 *	DVT 8/14/03 MATLAB_SINGLE_INSTANCE_FOR_MENU_IMPORT							*
 *------------------------------------------------------------------------------*/
#ifndef _EXTERNAPPS_H
#define _EXTERNAPPS_H

#include <common.h>

#ifndef _STRING_H
#include <string.h>		// Most likely will need strings
#endif // _STRING_H

#include <OC_types.h>	// Structures used in Origin internal functions

#ifndef _WKSHEET_H
#include <Wksheet.h>
#endif // _WKSHEET_H

/**+
http://ocwiki.originlab.com/index.php?title=Category:Matlab_(class)
*/
class Matlab
{
public:
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-Matlab
	*/
	Matlab( BOOL bAttach = TRUE, BOOL bSingle = FALSE, BOOL bKeepMatlabRunning = FALSE ); // Constructor for Matlab class.
	//Matlab(); // Default constructor for Matlab class.
	//Matlab(BOOL bAttach =TRUE); // Constructor for Matlab class.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-Attach
	*/
	BOOL	Attach( BOOL bUseRunningInstance=TRUE, BOOL bSingle = FALSE, BOOL bKeepMatlabRunning = FALSE );
	//BOOL	Attach(BOOL bUseRunningInstance=TRUE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-Detach
	*/
	BOOL	Detach();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-Execute
	*/
	string	Execute(LPCSTR lpcszCommand);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-Execute
	*/
	BOOL	Execute(LPCSTR lpcszCommand, string &strReturn);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-PutMatrix
	*/
	BOOL	PutMatrix(LPCSTR lpcszMatrixName, Matrix *pmmReal, Matrix *pmmImag = NULL, LPCSTR lpcszMatLabWorkspace = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-GetMatrix
	*/
	BOOL	GetMatrix(LPCSTR lpcszMatrixName, Matrix *pmmReal, Matrix *pmmImag = NULL, LPCSTR lpcszMatLabWorkspace = NULL);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-GetString
	*/
	string	GetString( LPCSTR lpcszStringName, LPCSTR lpcszMatLabWorkspace = NULL );
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-PutString
	*/
	BOOL	PutString( LPCSTR lpcszStringName, LPCSTR lpcszString, LPCSTR lpcszMatLabWorkspace = NULL );

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-MinimizeCommandWindow
	*/
	void	MinimizeCommandWindow();

	/**#
			Maximizes Matlab command window.
			
			Note: Not supported in Matlab 6.5 and earlier.
		Example:
			// Assumes	Matlab object successfully created, i.e. communication established
			matObj.MaximizeCommandWindow();
		SeeAlso:
			Matlab::MinimizeCommandWindow
	*/
	//void	MaximizeCommandWindow();

	/**#
			Closes Matlab.
			
			Note: Not supported in Matlab 6.5 and earlier
		Example:
			// Assumes	Matlab object successfully created, i.e. communication established
			matObj.Quit();
	*/
	//void	Quit();

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-Visible
	*/
	int		Visible;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Matlab-KeepMatlabRunning
	*/
	BOOL	KeepMatlabRunning;
};

#endif //_EXTERNAPPS_H
